<?php
	require('../lib/fpdf16/fpdf.php');

	/**
	* 
	*/
	class VariableStream
	{
		private $varname;
		private $position;
		function stream_open($path,$mode,$options,&$opened_path)
		{
			$url = parse_url($path);
			$this-> varname = $url['host'];
			if (!isset($GLOBALS[$this->varname])) {
				trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
				return false;

			}
			$this->position = 0;
			return true;
		}


		function stream_read($count)
		{
			$ret = substr($GLOBALS[$this->varname], $this->position,$count);
			$this->position+= strlen($ret);
			return $ret;


		}
		function stream_eof()
		{
			return $this->position >= strlen($GLOBALS[$this->varname]);
		}
		function stream_tell()
		{
			return $this->position;
		}
		function stream_seek($offset,$whence)
		{
			if($whence==SEEK_SET)
			{
				$this->position = $offset;
				return true;

			}
			return false;

		}
		function stream_stat()
		{
			return array();
		}
	}
	/**
	* 
	*/
	class PDF_MemImage extends FPDF 
	{
		
		function __construct($orientation='P',$unit='mm',$format='A4')

		{
			parent:: __construct($orientation,$unit,$format);
			stream_wrapper_register('var', 'VariableStream');
		}

		function MemImage($data,$x=null,$y=nulll,$w=0,$h=0,$link='')
		{
			$v = 'img'.md5($data);
			$GLOBALS[$v] = $data;
			$a = getimagesize('var://'.$v);
			if (!$a) 
				$this-> Error('Invalid image data');
			$type = substr(strstr($a['mime'],'/'), 1);
			$this->Image('var://'.$v,$x,$y,$w,$h,$type,$link);
			unset($GLOBALS[$v]);
			

		}
		function GDImage($im,$x= null,$y=null,$w=0,$h=0,$link='')
		{

			ob_start();
			imagepng($im);
			$data = ob_get_clean();
			$this -> MemImage($data,$x,$y,$w,$h,$link);
		}

	}

?>